/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.conndata;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rcs.conndata.UpdatableFile;
import com.ibm.hwmca.fw.util.FileUtilities;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.Translator;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class RetainUpdatableFile
extends UpdatableFile
implements Serializable {
    private static final long serialVersionUID = -7117661583156764501L;
    private static final String TRACE_MASKT = "XRCSRUFT";
    private static final String TRACE_MASKF = "XRCSRUFF";
    private static final String TRACE_MASKD = "XRCSRUFD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-RetnUpdF");
    private String retainKey;
    private int lrecl;
    private static final String EXT_BACKUP = "bak";
    private static final int FILE_SIZE_RECORD = 1;
    private static final int FILE_SIZE_INDEX = 13;
    private static final int FILE_SIZE_LENGTH = 5;
    private static final int FILE_GEN_RECORD = 2;
    private static final int FILE_GEN_INDEX = 2;
    private static final int FILE_GEN_LENGTH = 8;

    protected RetainUpdatableFile(File updatable, File staged, String retainKey, int lrecl) {
        super(updatable, staged);
        if (retainKey == null || retainKey.equals("")) {
            throw new IllegalArgumentException("Null or empty retain key specified");
        }
        if (lrecl <= 0) {
            throw new IllegalArgumentException("Invalid lrecl specified: " + lrecl);
        }
        this.retainKey = retainKey;
        this.lrecl = lrecl;
        Trace.trace(TRACE_MASKT, "<> " + this.toString());
    }

    public String getRetainKey() {
        return this.retainKey;
    }

    public int getLrecl() {
        return this.lrecl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getVersion() {
        block13: {
            Trace.trace("XRCSRUFT", "-> getVersion() " + this.updatable.getAbsolutePath());
            version = "";
            var2_2 = this;
            synchronized (var2_2) {
                from = null;
                try {
                    try {
                        from = new BufferedReader(new FileReader(this.updatable));
                        line = null;
                        record = 0;
                        while ((line = from.readLine()) != null) {
                            if (++record != 2) continue;
                            version = line.substring(2, 10);
                            break;
                        }
                    }
                    catch (Exception e) {
                        Trace.trace("XRCSRUFF", "Exception: " + e.getMessage());
                        new FrameworkLog(RetainUpdatableFile.classLogInfo, 1936, e).log();
                        var7_8 = null;
                        if (from != null) {
                            try {
                                from.close();
                            }
                            catch (IOException ioe) {}
                        }
                        break block13;
                    }
                    var7_7 = null;
                    if (from == null) break block13;
                }
                catch (Throwable var6_13) {
                    var7_9 = null;
                    if (from == null) throw var6_13;
                    ** try [egrp 3[TRYBLOCK] [4 : 170->177)] { 
lbl37:
                    // 1 sources

                    from.close();
                    throw var6_13;
lbl39:
                    // 1 sources

                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw var6_13;
                }
                try {}
                catch (IOException ioe) {}
                from.close();
            }
        }
        Trace.trace("XRCSRUFT", "<- getVersion() " + version);
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List getData() throws Exception {
        ArrayList<String> data;
        block11: {
            Trace.trace(TRACE_MASKT, "-> getData() " + this.updatable.getAbsolutePath());
            data = new ArrayList<String>();
            RetainUpdatableFile retainUpdatableFile = this;
            synchronized (retainUpdatableFile) {
                BufferedReader from = null;
                try {
                    try {
                        from = new BufferedReader(new FileReader(this.updatable));
                        String line = null;
                        int record = 0;
                        while ((line = from.readLine()) != null) {
                            if (++record == 2) {
                                String version = line.substring(2, 10);
                                Trace.trace(TRACE_MASKF, "version=" + version);
                            }
                            if (line.substring(0, 1).equals("*")) continue;
                            data.add(line);
                        }
                        Object var8_9 = null;
                        if (from == null) break block11;
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "Exception: " + e.getMessage());
                        HException he = new HException(e);
                        new FrameworkLog(classLogInfo, 1936, he).log();
                        throw he;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (from == null) throw throwable;
                    try {
                        from.close();
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException ioe) {}
                from.close();
            }
        }
        Trace.trace(TRACE_MASKT, "<- getData() " + data.size());
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void refresh() throws Exception {
        block29: {
            Trace.trace(TRACE_MASKT, "-> refresh() " + this.updatable.getAbsolutePath());
            Trace.trace(TRACE_MASKF, "staged=" + this.staged.getAbsolutePath());
            File tempDir = null;
            try {
                tempDir = new File(BaseFileControl.getFilePath("tmp"));
                Trace.trace(TRACE_MASKF, "tempDir=" + tempDir.getAbsolutePath());
            }
            catch (Exception exception) {
                // empty catch block
            }
            RetainUpdatableFile retainUpdatableFile = this;
            synchronized (retainUpdatableFile) {
                BufferedWriter to;
                BufferedInputStream from;
                if (tempDir == null) {
                    Trace.trace(TRACE_MASKF, "Unable to obtain temporary directory");
                } else if (!this.staged.exists()) {
                    Trace.trace(TRACE_MASKF, this.staged.getAbsolutePath() + " does not exist");
                } else {
                    IOException ioe32;
                    block28: {
                        block27: {
                            File tempStaged = null;
                            from = null;
                            to = null;
                            tempStaged = File.createTempFile("iqy", ".tmp", tempDir);
                            Trace.trace(TRACE_MASKF, "tempStaged=" + tempStaged.getAbsolutePath());
                            from = new BufferedInputStream(new FileInputStream(this.staged));
                            to = new BufferedWriter(new FileWriter(tempStaged));
                            int bytesRead = 0;
                            byte[] buffer = new byte[this.lrecl];
                            String line = "";
                            int records = 0;
                            char[] spaces = new char[this.lrecl];
                            for (int i = 0; i < this.lrecl; ++i) {
                                spaces[i] = 32;
                            }
                            String emptyLine = new String(spaces);
                            do {
                                bytesRead = from.read(buffer);
                                ++records;
                                line = Translator.fromEbcdic(buffer);
                                if (line.length() != this.lrecl || line.equals(emptyLine)) continue;
                                to.write(line);
                                to.newLine();
                            } while (bytesRead != -1);
                            try {
                                to.flush();
                                to.close();
                            }
                            catch (IOException ioe2) {
                                // empty catch block
                            }
                            if (this.isValid(tempStaged)) {
                                Trace.trace(TRACE_MASKF, tempStaged.getAbsolutePath() + " is valid");
                                File backup = new File(this.updatable.getAbsolutePath() + "." + EXT_BACKUP);
                                FileUtilities.move(this.updatable, backup);
                                FileUtilities.move(tempStaged, this.updatable);
                                break block27;
                            }
                            Trace.trace(TRACE_MASKF, tempStaged.getAbsolutePath() + " not valid");
                            Trace.trace(TRACE_MASKF, this.updatable.getAbsolutePath() + " left unchanged");
                        }
                        Object var14_18 = null;
                        if (to == null) break block28;
                        try {
                            to.close();
                        }
                        catch (IOException ioe32) {
                            // empty catch block
                        }
                    }
                    if (from != null) {
                        try {
                            from.close();
                        }
                        catch (IOException ioe32) {}
                    }
                }
                break block29;
                {
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "Exception: " + e.getMessage());
                        HException he = new HException(e);
                        new FrameworkLog(classLogInfo, 1936, he).log();
                        throw he;
                    }
                }
                catch (Throwable throwable) {
                    IOException ioe32;
                    Object var14_19 = null;
                    if (to != null) {
                        try {
                            to.close();
                        }
                        catch (IOException ioe32) {
                            // empty catch block
                        }
                    }
                    if (from != null) {
                        try {
                            from.close();
                        }
                        catch (IOException ioe32) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- refresh()");
    }

    private boolean isValid(File verifyFile) {
        Trace.trace(TRACE_MASKT, "-> isValid(" + verifyFile.getAbsolutePath() + ")");
        boolean isValid = true;
        try {
            List data;
            String version;
            RetainUpdatableFile temp = new RetainUpdatableFile(verifyFile, verifyFile, this.getRetainKey(), this.getLrecl());
            int records = temp.getNumOfRecords();
            int fileSize = temp.getFileSizeFromHeader();
            if (records != fileSize) {
                Trace.trace(TRACE_MASKF, "Number of records (" + records + ") " + "not equal to file size in header (" + fileSize + ")");
                isValid = false;
            }
            if ((version = (String)temp.getVersion()).equals("")) {
                Trace.trace(TRACE_MASKF, "No version indicator found");
                isValid = false;
            }
            if ((data = temp.getData()).size() <= 0) {
                Trace.trace(TRACE_MASKF, "No data lines found");
                isValid = false;
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e.getMessage());
            isValid = false;
        }
        Trace.trace(TRACE_MASKT, "<- isValid() " + isValid);
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getFileSizeFromHeader() {
        block14: {
            Trace.trace("XRCSRUFT", "-> getFileSizeFromHeader() " + this.updatable.getAbsolutePath());
            fileSize = -1;
            var2_2 = this;
            synchronized (var2_2) {
                from = null;
                try {
                    try {
                        from = new BufferedReader(new FileReader(this.updatable));
                        line = null;
                        record = 0;
                        while ((line = from.readLine()) != null) {
                            if (++record != 1) continue;
                            size = line.substring(13, 18);
                            Trace.trace("XRCSRUFF", "file size record=" + line);
                            Trace.trace("XRCSRUFF", "size=" + size);
                            try {
                                fileSize = Integer.parseInt(size);
                                break;
                            }
                            catch (NumberFormatException nfe) {
                                break;
                            }
                        }
                        var9_9 = null;
                        if (from == null) break block14;
                    }
                    catch (Exception e) {
                        Trace.trace("XRCSRUFF", "Exception: " + e.getMessage());
                        new FrameworkLog(RetainUpdatableFile.classLogInfo, 1936, e).log();
                        var9_10 = null;
                        if (from != null) {
                            try {
                                from.close();
                            }
                            catch (IOException ioe) {}
                        }
                        break block14;
                    }
                }
                catch (Throwable var8_15) {
                    var9_11 = null;
                    if (from == null) throw var8_15;
                    ** try [egrp 4[TRYBLOCK] [5 : 232->239)] { 
lbl42:
                    // 1 sources

                    from.close();
                    throw var8_15;
lbl44:
                    // 1 sources

                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw var8_15;
                }
                try {}
                catch (IOException ioe) {}
                from.close();
            }
        }
        Trace.trace("XRCSRUFT", "<- getFileSizeFromHeader() " + fileSize);
        return fileSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getNumOfRecords() {
        block12: {
            Trace.trace("XRCSRUFT", "-> getNumOfRecords() " + this.updatable.getAbsolutePath());
            records = 0;
            var2_2 = this;
            synchronized (var2_2) {
                from = null;
                try {
                    try {
                        from = new BufferedReader(new FileReader(this.updatable));
                        line = null;
                        while ((line = from.readLine()) != null) {
                            ++records;
                        }
                        var6_6 = null;
                        if (from == null) break block12;
                    }
                    catch (Exception e) {
                        Trace.trace("XRCSRUFF", "Exception: " + e.getMessage());
                        new FrameworkLog(RetainUpdatableFile.classLogInfo, 1936, e).log();
                        var6_7 = null;
                        if (from != null) {
                            try {
                                from.close();
                            }
                            catch (IOException ioe) {}
                        }
                        break block12;
                    }
                }
                catch (Throwable var5_12) {
                    var6_8 = null;
                    if (from == null) throw var5_12;
                    ** try [egrp 3[TRYBLOCK] [4 : 151->158)] { 
lbl33:
                    // 1 sources

                    from.close();
                    throw var5_12;
lbl35:
                    // 1 sources

                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw var5_12;
                }
                try {}
                catch (IOException ioe) {}
                from.close();
            }
        }
        Trace.trace("XRCSRUFT", "<- getNumOfRecords() " + records);
        return records;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[RetainUpdatableFile: updatable=" + this.updatable.getAbsolutePath() + ", ");
        sb.append("staged=" + this.staged.getAbsolutePath() + ", ");
        sb.append("retainKey=" + this.retainKey + ", ");
        sb.append("lrecl=" + this.lrecl + "]");
        return sb.toString();
    }
}

